/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.figures;

import CH.ifa.draw.framework.Connector;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.figures.CutConnectFigure;
import DE.siemens.ad.pdraw.figures.constraints.CuttedConnectionConstraint;
import DE.siemens.ad.pdraw.standard.CCRightConnector;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import java.awt.Point;
import java.awt.Rectangle;

public class OutputCutConnectFigure
extends CutConnectFigure {
    static final long serialVersionUID = 2705584281821697674L;
    private int outputCutConnectFigureSerializedDataVersion = 1;

    public OutputCutConnectFigure() {
    }

    public OutputCutConnectFigure(Point p) {
        int diff = CutConnectFigure.FIGURE_SIZE;
        this.addPoint(p.x - diff * 3, p.y - diff);
        this.addPoint(p.x, p.y - diff);
        this.addPoint(p.x, p.y + diff);
        this.addPoint(p.x - diff * 3, p.y + diff);
        this.addPoint(p.x - diff * 2, p.y);
        this.addPoint(p.x - diff * 3, p.y - diff);
        Point p100 = new Point(p.x, p.y);
        this.fBasePoints[0] = new Point(p100.x - FIGURE_SIZE * 3, p100.y - FIGURE_SIZE);
        this.fBasePoints[1] = new Point(p100.x, p100.y - FIGURE_SIZE);
        this.fBasePoints[2] = new Point(p100.x, p100.y + FIGURE_SIZE);
        this.fBasePoints[3] = new Point(p100.x - FIGURE_SIZE * 3, p100.y + FIGURE_SIZE);
        this.fBasePoints[4] = new Point(p100.x - FIGURE_SIZE * 2, p100.y);
        this.fBasePoints[5] = new Point(p100.x - FIGURE_SIZE * 3, p100.y - FIGURE_SIZE);
    }

    public Connector connectorAt(int x, int y) {
        return new CCRightConnector(this);
    }

    public Point connectorStartPoint() {
        Rectangle r = this.parentDisplayBox();
        return new Point(r.x + r.width, r.y + r.height / 2);
    }

    void newMethod() {
    }

    public void setDescription(LogoDrawing logoDrawing) {
        StringBuffer description = new StringBuffer();
        CuttedConnectionConstraint ccc = (CuttedConnectionConstraint)this.getConstraint().getContainer();
        OutBlockConnector outBlockConnector = ccc.getOutBlockConnector();
        InBlockConnector inBlockConnector = ccc.getInBlockConnector();
        Block outBlock = outBlockConnector.getOwner();
        Block inBlock = inBlockConnector.getOwner();
        BlockFigure outBlockFigure = logoDrawing.getBlockFigure(outBlock);
        BlockFigure inBlockFigure = logoDrawing.getBlockFigure(inBlock);
        if (inBlockFigure != null && outBlockFigure != null && inBlockFigure.getPageNumber() != outBlockFigure.getPageNumber()) {
            description.append(outBlockFigure.getPageNumber());
            description.append("/");
        }
        if (outBlock.getNumberType() == -2) {
            description.append(((DeputyBlock)outBlock).getParent().getNumberString() + "/");
            if (!outBlockConnector.getName().equals("")) {
                description.append(outBlockConnector.getName());
            } else {
                description.append(outBlock.getOutConnectorPosition(outBlockConnector) + 1);
            }
        } else {
            description.append(outBlock.getNumberString());
        }
        this.fCCTextFigure.setText(description.toString());
    }

    public String getTooltip(LogoDrawing logoDrawing) {
        StringBuffer description = new StringBuffer("<html>");
        CuttedConnectionConstraint ccc = (CuttedConnectionConstraint)this.getConstraint().getContainer();
        OutBlockConnector outBlockConnector = ccc.getOutBlockConnector();
        InBlockConnector inBlockConnector = ccc.getInBlockConnector();
        Block outBlock = outBlockConnector.getOwner();
        Block inBlock = inBlockConnector.getOwner();
        BlockFigure outBlockFigure = logoDrawing.getBlockFigure(outBlock);
        BlockFigure inBlockFigure = logoDrawing.getBlockFigure(inBlock);
        if (inBlockFigure != null && outBlockFigure != null && inBlockFigure.getPageNumber() != outBlockFigure.getPageNumber()) {
            description.append(Language.getString("figure.cuttedConnection.tooltip.page", "Page"));
            description.append(": ");
            description.append(outBlockFigure.getPageNumber());
            description.append("<br>");
        }
        description.append(Language.getString("figure.cuttedConnection.tooltip.block", "Block"));
        description.append(": ");
        description.append(outBlock.getNumberString());
        return description.toString();
    }
}

